/*
 * Decompiled with CFR 0.152.
 */
package azmalent.terraincognita.common.world.feature;

import azmalent.terraincognita.common.block.plants.HangingMossBlock;
import azmalent.terraincognita.common.registry.ModBlocks;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class HangingMossFeature
extends Feature<NoFeatureConfig> {
    private static final int MIN_VERTICAL_SPACE = 3;
    private static final int MIN_Y = 40;
    private static final int MAX_Y = 96;
    private static final int X_SPREAD = 6;
    private static final int Y_SPREAD = 4;
    private static final int Z_SPREAD = 6;
    private static final int TRIES = 20;

    public HangingMossFeature() {
        super(NoFeatureConfig.field_236558_a_);
    }

    public boolean generate(@Nonnull ISeedReader world, @Nonnull ChunkGenerator generator, @Nonnull Random rand, @Nonnull BlockPos pos, @Nonnull NoFeatureConfig config) {
        int y = rand.nextInt(56) + 40;
        BlockPos centerPos = new BlockPos(pos.func_177958_n(), y, pos.func_177952_p());
        BlockPos.Mutable nextPos = new BlockPos.Mutable();
        boolean success = false;
        BlockState moss = ModBlocks.HANGING_MOSS.getBlock().func_176223_P();
        for (int i = 0; i < 20; ++i) {
            nextPos.func_239621_a_((Vector3i)centerPos, rand.nextInt(7) - rand.nextInt(7), rand.nextInt(5) - rand.nextInt(5), rand.nextInt(7) - rand.nextInt(7));
            if (nextPos.func_177956_o() < 40 || !this.hasEnoughVerticalSpace(world, (BlockPos)nextPos) || !moss.func_196955_c((IWorldReader)world, (BlockPos)nextPos) || world.func_180495_p(nextPos.func_177984_a()).func_203425_a(ModBlocks.HANGING_MOSS.getBlock())) continue;
            if (rand.nextBoolean()) {
                world.func_180501_a((BlockPos)nextPos, moss, 2);
            } else {
                world.func_180501_a((BlockPos)nextPos, (BlockState)moss.func_206870_a(HangingMossBlock.VARIANT, (Comparable)((Object)HangingMossBlock.Variant.TOP)), 2);
                world.func_180501_a(nextPos.func_177977_b(), (BlockState)moss.func_206870_a(HangingMossBlock.VARIANT, (Comparable)((Object)HangingMossBlock.Variant.BOTTOM)), 2);
            }
            success = true;
        }
        return success;
    }

    private boolean hasEnoughVerticalSpace(ISeedReader reader, BlockPos pos) {
        for (int i = 0; i < 3; ++i) {
            if (reader.func_175623_d(pos.func_177979_c(i))) continue;
            return false;
        }
        return true;
    }
}

